(function ($) {
    "use strict";

    //Scroll back to top
    $(document).ready(function () {

        var progressPath = document.querySelector('.progress-wrap path');
        var pathLength = progressPath.getTotalLength();
        progressPath.style.transition = progressPath.style.WebkitTransition = 'none';
        progressPath.style.strokeDasharray = pathLength + ' ' + pathLength;
        progressPath.style.strokeDashoffset = pathLength;
        progressPath.getBoundingClientRect();
        progressPath.style.transition = progressPath.style.WebkitTransition = 'stroke-dashoffset 10ms linear';
        var updateProgress = function () {
            var scroll = $(window).scrollTop();
            var height = $(document).height() - $(window).height();
            var progress = pathLength - (scroll * pathLength / height);
            progressPath.style.strokeDashoffset = progress;
        }
        updateProgress();
        $(window).scroll(updateProgress);
        var offset = 50;
        var duration = 550;
        jQuery(window).on('scroll', function () {
            if (jQuery(this).scrollTop() > offset) {
                jQuery('.progress-wrap').addClass('active-progress');
            } else {
                jQuery('.progress-wrap').removeClass('active-progress');
            }
        });
        jQuery('.progress-wrap').on('click', function (event) {
            event.preventDefault();
            jQuery('html, body').animate({ scrollTop: 0 }, duration);
            return false;
        })

    });

    // Document Ready
    $(document).ready(function () {

        // menu_toggle
        $('.menu_toggle').on('click', function (event) {
            event.preventDefault();
            $("body").toggleClass('menu_active');
        });

        // site_header
        $(document).ready(function () {
            function toggleSticky() {
                if ($(window).scrollTop() >= 100) {
                    $(".site_header").addClass("sticky");
                } else {
                    $(".site_header").removeClass("sticky");
                }
            }

            // Run once on page load (handles refresh case)
            toggleSticky();

            // Run on scroll
            $(window).on("scroll", function () {
                toggleSticky();
            });
        });

        // click_boxes
        $('.click_box').on('mouseenter', function () {
            $(this).addClass('hovered');
        });
        $('.click_box').on('mousemove', function (e) {
            let boxOffset = $(this).offset();

            let x = e.pageX - boxOffset.left;
            let y = e.pageY - boxOffset.top;

            $(this).find('.click_text').css({
                left: x,
                top: y
            });
        });
        $('.click_box').on('mouseleave', function () {
            $(this).removeClass('hovered');
        });

        // Loadmore
        $('.loadmore_btn').on('click', function () {
            var $box = $('.stories_boxes');
            var scrollAmount = $box.outerHeight();

            $box.animate(
                {
                    scrollTop: $box.scrollTop() + scrollAmount
                },
                700 // animation speed (ms)
            );

            $box.addClass('overflow-auto');
        });

        // Accordion
        $('.accordion_btn').on('click', function () {
            var $item = $(this).closest('.accordion_item');
            var $content = $item.find('.accordion_content');

            // If already open → close it
            if ($item.hasClass('active')) {
                $content.slideUp(300);
                $item.removeClass('active');
                return;
            }

            // Close all others
            $('.accordion_item.active .accordion_content').slideUp(300);
            $('.accordion_item.active').removeClass('active');

            // Open clicked one
            $item.addClass('active');
            $content.slideDown(300);
        });

    });

})(jQuery);
