(function ($) {
    "use strict";

    // Document Ready
    $(document).ready(function () {

        // menu_toggle
        $('.menu_toggle').on('click', function (event) {
            event.preventDefault();
            $("body").toggleClass('menu_active');
        });

        // site_header sticky
        $(document).ready(function () {
            function toggleSticky() {
                if ($(window).scrollTop() >= 100) {
                    $(".site_header").addClass("sticky");
                } else {
                    $(".site_header").removeClass("sticky");
                }
            }

            // Run once on page load (handles refresh case)
            toggleSticky();

            // Run on scroll
            $(window).on("scroll", function () {
                toggleSticky();
            });
        });

        // menu_link
        $(document).ready(function () {
            let forceActive = false; // Flag to force clicked menu link as active

            // Smooth scroll on menu click
            $(".menu_link").on("click", function (e) {
                e.preventDefault();
                var target = $(this).attr("href");
                var offsetTop = $(target).offset().top;
                var height = $('.site_header').height();

                // Extra offset for specific sections
                if (target === "#Kontakti") offsetTop -= height + 0;
                if (target === "#Partneri") offsetTop -= height - 60;
                if (target === "#Galerija") offsetTop -= height - 60;
                if (target === "#Pakalpojumi") offsetTop -= height - 100;
                if (target === "#Pieredze") offsetTop -= height - 80;



                // Immediately activate clicked menu link
                $(".menu_link").removeClass("active");
                $(this).addClass("active");

                // Set forceActive to prevent scroll from overriding
                forceActive = true;

                $("html, body").animate(
                    { scrollTop: offsetTop },
                    800, // scroll speed
                    function () {
                        // Animation complete, allow normal scroll updates again
                        forceActive = false;
                        updateActiveMenu(); // Ensure final section gets active if needed
                    }
                );

                $("body").removeClass('menu_active');
            });

            function updateActiveMenu() {
                if (forceActive) return; // Do nothing if forced active by click

                var scrollPos = $(window).scrollTop();
                $(".section").each(function () {
                    var top = $(this).offset().top - 100;
                    var bottom = top + $(this).outerHeight();
                    var id = $(this).attr("id");

                    if (scrollPos >= top && scrollPos < bottom) {
                        $(".menu_link").removeClass("active");
                        $('.menu_link[href="#' + id + '"]').addClass("active");
                    }
                });
            }

            // Run on scroll
            $(window).on("scroll", updateActiveMenu);

            // Run once on page load
            updateActiveMenu();
        });

    });

})(jQuery);
