(function ($) {
    "use strict";



    //Scroll back to top
    $(document).ready(function () {

        var progressPath = document.querySelector('.progress-wrap path');
        var pathLength = progressPath.getTotalLength();
        progressPath.style.transition = progressPath.style.WebkitTransition = 'none';
        progressPath.style.strokeDasharray = pathLength + ' ' + pathLength;
        progressPath.style.strokeDashoffset = pathLength;
        progressPath.getBoundingClientRect();
        progressPath.style.transition = progressPath.style.WebkitTransition = 'stroke-dashoffset 10ms linear';
        var updateProgress = function () {
            var scroll = $(window).scrollTop();
            var height = $(document).height() - $(window).height();
            var progress = pathLength - (scroll * pathLength / height);
            progressPath.style.strokeDashoffset = progress;
        }
        updateProgress();
        $(window).scroll(updateProgress);
        var offset = 50;
        var duration = 550;
        jQuery(window).on('scroll', function () {
            if (jQuery(this).scrollTop() > offset) {
                jQuery('.progress-wrap').addClass('active-progress');
            } else {
                jQuery('.progress-wrap').removeClass('active-progress');
            }
        });
        jQuery('.progress-wrap').on('click', function (event) {
            event.preventDefault();
            jQuery('html, body').animate({ scrollTop: 0 }, duration);
            return false;
        })

    });

    // Document Ready
    $(document).ready(function () {


        // menu_toggle
        $('.menu_toggle').on('click', function (event) {
            event.preventDefault();
            $("body").toggleClass('menu_active');
        });

        // site_header
        $(document).ready(function () {
            function toggleSticky() {
                if ($(window).scrollTop() >= 100) {
                    $(".site_header").addClass("sticky");
                } else {
                    $(".site_header").removeClass("sticky");
                }
            }

            // Run once on page load (handles refresh case)
            toggleSticky();

            // Run on scroll
            $(window).on("scroll", function () {
                toggleSticky();
            });
        });

        // Accordion
        $(document).ready(function () {
            // Initialize all accordions on the page
            $('.faq-accordion').each(function () {
                const $accordion = $(this);

                // Calculate initial heights for items that start as active
                $accordion.find('.faq-item.active').each(function () {
                    const $item = $(this);
                    const $answer = $item.find('.faq-answer');
                    const $content = $answer.find('.faq-answer-content');
                    const contentHeight = $content.outerHeight(true);
                    const paddingTop = parseFloat($answer.css('padding-top')) || 0;
                    $answer.css('max-height', (contentHeight + paddingTop) + 'px');
                });

                // Handle click on question wrapper
                $accordion.find('.faq-question-wrapper').on('click', function (e) {
                    e.preventDefault();

                    const $item = $(this).closest('.faq-item');
                    const $answer = $item.find('.faq-answer');
                    const $content = $answer.find('.faq-answer-content');

                    // Check if this item is already active
                    const isActive = $item.hasClass('active');

                    if (isActive) {
                        // Close this item
                        $item.removeClass('active');
                        $answer.css('max-height', '0');
                    } else {
                        // Close all other items in this accordion
                        $accordion.find('.faq-item').each(function () {
                            const $otherItem = $(this);
                            if (!$otherItem.is($item)) {
                                const $otherAnswer = $otherItem.find('.faq-answer');
                                $otherItem.removeClass('active');
                                $otherAnswer.css('max-height', '0');
                            }
                        });

                        // Open this item
                        $item.addClass('active');

                        // Calculate the full height including padding
                        const contentHeight = $content.outerHeight(true);
                        const paddingTop = parseFloat($answer.css('padding-top')) || 0;
                        $answer.css('max-height', (contentHeight + paddingTop + 20) + 'px');
                    }
                });
            });

            // Recalculate heights on window resize
            let resizeTimer;
            $(window).on('resize', function () {
                clearTimeout(resizeTimer);
                resizeTimer = setTimeout(function () {
                    $('.faq-item.active').each(function () {
                        const $item = $(this);
                        const $answer = $item.find('.faq-answer');
                        const $content = $answer.find('.faq-answer-content');
                        const contentHeight = $content.outerHeight(true);
                        const paddingTop = parseFloat($answer.css('padding-top')) || 0;
                        $answer.css('max-height', (contentHeight + paddingTop + 20) + 'px');
                    });
                }, 250);
            });
        });

        // ================================================= //
        $(document).ready(function () {

            // Toggle dropdown
            $('.selected_btn').on('click', function (e) {
                e.stopPropagation();
                $('.select_wrapper').not($(this).closest('.select_wrapper')).removeClass('active');
                $(this).closest('.select_wrapper').toggleClass('active');
            });

            // Select option
            $('.select_dropdown .select_btn').on('click', function () {
                const imgSrc = $(this).find('img').attr('src');
                const imgAlt = $(this).find('img').attr('alt');

                $(this)
                    .closest('.select_wrapper')
                    .find('.selected_btn img')
                    .attr({ src: imgSrc, alt: imgAlt });

                $(this).closest('.select_wrapper').removeClass('active');
            });

            // Close on outside click
            $(document).on('click', function () {
                $('.select_wrapper').removeClass('active');
            });

        });
    

    });

})(jQuery);
